/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.core;

import com.aptana.core.epl.IMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.webserver.core.AbstractWebServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.Messages;
import com.aptana.webserver.core.URLtoURIMapper;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWebServer
extends AbstractWebServer {
    private static final String ELEMENT_BASE_URL = "baseURL";
    private static final String ELEMENT_DOCUMENT_ROOT = "documentRoot";
    private URL baseURL;
    private URI documentRoot;

    @Override
    public URL getBaseURL() {
        return this.baseURL;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.baseURL != null) {
            memento.createChild(ELEMENT_BASE_URL).putTextData(this.baseURL.toExternalForm());
        }
        if (this.documentRoot != null) {
            memento.createChild(ELEMENT_DOCUMENT_ROOT).putTextData(this.documentRoot.toASCIIString());
        }
    }

    @Override
    public void loadState(IMemento memento) {
        String text;
        super.loadState(memento);
        IMemento child = memento.getChild(ELEMENT_BASE_URL);
        if (child != null) {
            try {
                this.baseURL = new URL(child.getTextData());
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            }
        }
        if ((child = memento.getChild(ELEMENT_DOCUMENT_ROOT)) != null && (text = child.getTextData()) != null) {
            try {
                this.documentRoot = URI.create(text);
            }
            catch (IllegalArgumentException e) {
                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            }
        }
    }

    @Override
    public URI getDocumentRoot() {
        return this.documentRoot;
    }

    public IPath getDocumentRootPath() {
        URI rootUri = this.getDocumentRoot();
        if (rootUri == null) {
            return null;
        }
        File docRoot = new File(rootUri);
        return Path.fromOSString((String)docRoot.getAbsolutePath());
    }

    public void setDocumentRootPath(IPath documentRoot) {
        this.setDocumentRoot(EFS.getLocalFileSystem().getStore(documentRoot).toURI());
    }

    @Override
    public String getHostname() {
        return this.getBaseURL().getHost();
    }

    @Override
    public int getPort() {
        return this.getBaseURL().getPort();
    }

    public void setBaseURL(URL url) {
        this.baseURL = url;
    }

    @Override
    public IStatus stop(boolean force, IProgressMonitor monitor) {
        return new Status(4, "com.aptana.webserver.core", Messages.SimpleWebServer_ERR_StopNotSupported);
    }

    @Override
    public IStatus start(String mode, IProgressMonitor monitor) {
        return new Status(4, "com.aptana.webserver.core", Messages.SimpleWebServer_ERR_StartNotSupported);
    }

    @Override
    public String getMode() {
        return null;
    }

    @Override
    public IServer.State getState() {
        return IServer.State.NOT_APPLICABLE;
    }

    @Override
    public ILaunch getLaunch() {
        return null;
    }

    @Override
    public IProcess[] getProcesses() {
        return new IProcess[0];
    }

    public URI resolve(IFileStore file) {
        return new URLtoURIMapper(this.getBaseURL(), this.getDocumentRoot()).resolve(file);
    }

    public IFileStore resolve(URI uri) {
        return new URLtoURIMapper(this.getBaseURL(), this.getDocumentRoot()).resolve(uri);
    }

    public void setDocumentRoot(URI uri) {
        this.documentRoot = uri;
    }

    @Override
    public Set<String> getAvailableModes() {
        return Collections.emptySet();
    }
}

